<div>
    <div class="p-4 mb-4 bg-white border border-gray-200 rounded-lg shadow-sm dark:border-gray-700 sm:p-6 dark:bg-gray-800 mx-4 my-4">
        <h3 class="mb-4 text-xl font-semibold dark:text-white">@lang('multipos::messages.settings.title')</h3>
        <p class="mb-6 text-gray-600 dark:text-gray-400">@lang('multipos::messages.settings.subtitle')</p>

        <!-- Machine Registration Info -->
        <div class="mb-6">
            <h4 class="mb-2 text-lg font-semibold text-gray-900 dark:text-white">
                @lang('multipos::messages.settings.machine_registration_title')
            </h4>
            <p class="text-gray-600 dark:text-gray-400">
                @lang('multipos::messages.settings.machine_registration_description')
            </p>
        </div>

        <!-- Status Guide -->
        <div class="mb-6">
            <h4 class="mb-2 text-lg font-semibold text-gray-900 dark:text-white">
                @lang('multipos::messages.settings.status_guide_title')
            </h4>
            <div class="space-y-2">
                <div class="flex items-center">
                    <span class="inline-block px-2 py-1 text-xs font-semibold text-white bg-green-500 rounded">@lang('multipos::messages.status.active')</span>
                    <span class="ml-3 text-gray-600 dark:text-gray-400">@lang('multipos::messages.status.active_description')</span>
                </div>
                <div class="flex items-center">
                    <span class="inline-block px-2 py-1 text-xs font-semibold text-white bg-orange-500 rounded">@lang('multipos::messages.status.pending')</span>
                    <span class="ml-3 text-gray-600 dark:text-gray-400">@lang('multipos::messages.status.pending_description')</span>
                </div>
                <div class="flex items-center">
                    <span class="inline-block px-2 py-1 text-xs font-semibold text-white bg-red-500 rounded">@lang('multipos::messages.status.declined')</span>
                    <span class="ml-3 text-gray-600 dark:text-gray-400">@lang('multipos::messages.status.declined_description')</span>
                </div>
            </div>
        </div>

        <!-- Machine Count Info -->
        <div class="mb-6 p-4 bg-gray-50 dark:bg-gray-700 rounded-lg">
            <div class="flex items-center justify-between">
                <span class="text-gray-700 dark:text-gray-300">
                    @lang('multipos::messages.settings.machine_count', ['count' => $machineCount])
                </span>
                @if($remainingSlots !== null)
                    <span class="text-gray-700 dark:text-gray-300">
                        @lang('multipos::messages.settings.remaining_slots', ['slots' => $remainingSlots])
                    </span>
                @else
                    <span class="text-gray-700 dark:text-gray-300">
                        @lang('multipos::messages.settings.unlimited')
                    </span>
                @endif
            </div>
        </div>

        <!-- Machines Table -->
        <div class="overflow-x-auto">
            <h4 class="mb-4 text-lg font-semibold text-gray-900 dark:text-white">
                @lang('multipos::messages.settings.registered_machines', ['branch' => branch()->name ?? 'N/A'])
            </h4>

            @if(count($machines) > 0)
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                @lang('multipos::messages.table.alias')
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                @lang('multipos::messages.table.machine_id')
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                @lang('multipos::messages.table.status')
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                @lang('multipos::messages.table.last_seen')
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                @lang('multipos::messages.table.registered')
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                @lang('multipos::messages.table.actions')
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach($machines as $machine)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                    {{ $machine['alias'] ?? 'N/A' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                    {{ $machine['device_id'] }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @php
                                        $statusColor = match($machine['status']) {
                                            'active' => 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200',
                                            'pending' => 'bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-200',
                                            'declined' => 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200',
                                            default => 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200',
                                        };
                                    @endphp
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full {{ $statusColor }}">
                                        @lang('multipos::messages.status.' . $machine['status'])
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                    {{ $machine['last_seen_at'] ? \Carbon\Carbon::parse($machine['last_seen_at'])->diffForHumans() : 'Never' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                    {{ \Carbon\Carbon::parse($machine['registered_at'])->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    @if($machine['status'] === 'pending')
                                        <button 
                                            wire:click="approve({{ $machine['id'] }})"
                                            class="text-green-600 hover:text-green-900 dark:text-green-400 dark:hover:text-green-300"
                                        >
                                            @lang('multipos::messages.actions.approve')
                                        </button>
                                        <button 
                                            wire:click="decline({{ $machine['id'] }})"
                                            class="ml-4 text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300"
                                        >
                                            @lang('multipos::messages.actions.decline')
                                        </button>
                                    @endif
                                    <button 
                                        wire:click="delete({{ $machine['id'] }})"
                                        class="ml-4 text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300"
                                    >
                                        @lang('multipos::messages.actions.delete')
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-8">
                    <p class="text-gray-500 dark:text-gray-400">@lang('multipos::messages.settings.no_machines')</p>
                </div>
            @endif
        </div>
    </div>
</div>

