<?php

namespace Modules\MultiPOS\Observers;

use Modules\MultiPOS\Entities\PosMachine;
use Modules\MultiPOS\Services\PosMachineCacheService;

class PosMachineObserver
{
    /**
     * Handle the PosMachine "created" event.
     */
    public function created(PosMachine $posMachine): void
    {
        PosMachineCacheService::clearMachineCache($posMachine->device_id, $posMachine->branch_id);
        PosMachineCacheService::clearBranchMachinesCache($posMachine->branch_id);
        PosMachineCacheService::clearMachineCountCache($posMachine->branch_id);
    }

    /**
     * Handle the PosMachine "updated" event.
     */
    public function updated(PosMachine $posMachine): void
    {
        PosMachineCacheService::clearMachineCache($posMachine->device_id, $posMachine->branch_id);
        PosMachineCacheService::clearBranchMachinesCache($posMachine->branch_id);
        PosMachineCacheService::clearMachineCountCache($posMachine->branch_id);
    }

    /**
     * Handle the PosMachine "deleted" event.
     */
    public function deleted(PosMachine $posMachine): void
    {
        PosMachineCacheService::clearMachineCache($posMachine->device_id, $posMachine->branch_id);
        PosMachineCacheService::clearBranchMachinesCache($posMachine->branch_id);
        PosMachineCacheService::clearMachineCountCache($posMachine->branch_id);
    }
}

