<?php

namespace Modules\Inventory\Observers;

use Modules\Inventory\Entities\Supplier;
use Modules\Inventory\Services\InventoryCacheService;

class SupplierObserver
{

    public function creating(Supplier $supplier)
    {
        if (restaurant()) {
            $supplier->restaurant_id = restaurant()->id;
        }
    }

    public function created(Supplier $supplier): void
    {
        // Clear restaurant cache when supplier is created
        InventoryCacheService::clearRestaurantCache($supplier->restaurant_id);
    }

    public function updated(Supplier $supplier): void
    {
        // Clear restaurant cache when supplier is updated
        InventoryCacheService::clearRestaurantCache($supplier->restaurant_id);
        
        // Also clear if restaurant changed
        if ($supplier->isDirty('restaurant_id')) {
            InventoryCacheService::clearRestaurantCache($supplier->getOriginal('restaurant_id'));
        }
    }

    public function deleted(Supplier $supplier): void
    {
        // Clear restaurant cache when supplier is deleted
        InventoryCacheService::clearRestaurantCache($supplier->restaurant_id);
    }
}
