<?php

namespace Modules\Inventory\Observers;

use App\Models\Branch;
use Modules\Inventory\Entities\Unit;
use Modules\Inventory\Entities\InventoryItemCategory;
use Modules\Inventory\Services\InventoryCacheService;

class BranchObserver
{

    public function created(Branch $branch): void
    {

        foreach (Unit::UNITS as $unit) {
            Unit::firstOrCreate(array_merge($unit, [
                'branch_id' => $branch->id
            ]));
        }

        foreach (InventoryItemCategory::CATEGORIES as $category) {
            InventoryItemCategory::firstOrCreate([
                'branch_id' => $branch->id,
                'name' => $category
            ]);
        }
        
        // Clear branch cache after creating default units and categories
        InventoryCacheService::clearBranchCache($branch->id);
    }

    public function updated(Branch $branch): void
    {
        // Clear branch cache when branch is updated (restaurant_id might change)
        InventoryCacheService::clearBranchCache($branch->id);
        
        // Also clear if restaurant changed
        if ($branch->isDirty('restaurant_id')) {
            InventoryCacheService::clearRestaurantCache($branch->getOriginal('restaurant_id'));
            InventoryCacheService::clearRestaurantCache($branch->restaurant_id);
        }
    }

    public function deleted(Branch $branch): void
    {
        // Clear branch cache when branch is deleted
        InventoryCacheService::clearBranchCache($branch->id);
    }
}
