<?php

namespace Modules\CashRegister\Observers;

use Modules\CashRegister\Entities\Denomination;
use Modules\CashRegister\Services\CashRegisterCacheService;

class DenominationObserver
{
    /**
     * Handle the Denomination "created" event.
     */
    public function created(Denomination $denomination): void
    {
        // Clear denomination cache when created
        if ($denomination->branch_id) {
            CashRegisterCacheService::clearBranchCache($denomination->branch_id);
        } else {
            // Clear for restaurant if no branch
            $branch = \App\Models\Branch::find($denomination->branch_id);
            if ($branch) {
                CashRegisterCacheService::clearBranchCache($branch->id);
            }
        }
    }

    /**
     * Handle the Denomination "updated" event.
     */
    public function updated(Denomination $denomination): void
    {
        // Clear denomination cache when updated
        if ($denomination->branch_id) {
            CashRegisterCacheService::clearBranchCache($denomination->branch_id);
        }
        
        // Also clear if branch or restaurant changed
        if ($denomination->isDirty('branch_id')) {
            if ($denomination->getOriginal('branch_id')) {
                CashRegisterCacheService::clearBranchCache($denomination->getOriginal('branch_id'));
            }
        }
        if ($denomination->isDirty('restaurant_id')) {
            $branch = \App\Models\Branch::where('restaurant_id', $denomination->restaurant_id)->first();
            if ($branch) {
                CashRegisterCacheService::clearBranchCache($branch->id);
            }
        }
    }

    /**
     * Handle the Denomination "deleted" event.
     */
    public function deleted(Denomination $denomination): void
    {
        // Clear denomination cache when deleted
        if ($denomination->branch_id) {
            CashRegisterCacheService::clearBranchCache($denomination->branch_id);
        }
    }
}

